/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.registry.structure;

import com.mojang.datafixers.util.Pair;
import com.redpxnda.respawnobelisks.mixin.STPAccessor;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class VillageAddition {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122883_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));

    private static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        Holder emptyProcessorList = processorListRegistry.m_206081_(EMPTY_PROCESSOR_LIST_KEY);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210512_((String)nbtPieceRL, (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            ((STPAccessor)pool).getTemplates().add((Object)piece);
        }
        ArrayList<Pair<StructurePoolElement, Integer>> listOfPieceEntries = new ArrayList<Pair<StructurePoolElement, Integer>>(((STPAccessor)pool).getRawTemplates());
        listOfPieceEntries.add((Pair<StructurePoolElement, Integer>)new Pair((Object)piece, (Object)weight));
        ((STPAccessor)pool).setRawTemplates(listOfPieceEntries);
    }

    public static void addNewVillageBuilding(MinecraftServer instance) {
        Registry templatePoolRegistry = (Registry)instance.m_206579_().m_6632_(Registry.f_122884_).orElseThrow();
        Registry processorListRegistry = (Registry)instance.m_206579_().m_6632_(Registry.f_122883_).orElseThrow();
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/plains/town_centers"), "respawnobelisks:village/plains_obelisk_01", 400);
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/taiga/town_centers"), "respawnobelisks:village/taiga_obelisk_01", 400);
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/desert/town_centers"), "respawnobelisks:village/desert_obelisk_01", 400);
        VillageAddition.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:village/savanna/town_centers"), "respawnobelisks:village/savanna_obelisk_01", 400);
    }
}

